<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Password Reset</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f9f9f9;
        }
        .header {
            background-color: #007bff;
            color: #fff;
            padding: 10px;
            text-align: center;
        }
        .content {
            padding: 20px;
            background-color: #fff;
            border: 1px solid #ddd;
        }
        .button {
            display: inline-block;
            padding: 10px 20px;
            background-color: #007bff;
            color: #fff;
            text-decoration: none;
            border-radius: 5px;
        }
        .footer {
            margin-top: 20px;
            text-align: center;
            font-size: 12px;
            color: #777;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Password Reset Request</h1>
        </div>
        <div class="content">
            <p>Hello <?php echo e($user->full_name); ?>,</p>
            <p>We received a request to reset your password. Click the button below to reset it:</p>
            <p style="text-align: center;">
                <a href="<?php echo e($resetLink); ?>" class="button">Reset Password</a>
            </p>
            <p>If you did not request a password reset, please ignore this email.</p>
            <p>This link will expire in 60 minutes.</p>
        </div>
        <div class="footer">
            <p>&copy; <?php echo e(date('Y')); ?> Your App Name. All rights reserved.</p>
        </div>
    </div>
</body>
</html><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/emails/password_reset.blade.php ENDPATH**/ ?>