@extends('admin.layouts.master')
@section('title')

@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
<script>
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<!-- Page Sidebar Ends-->
<div class="page-body">
    <!-- Modal -->
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">المتــاجــر</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسية</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">المتاجــر</li>
                    </ol>
                </div>
                <div class="col-sm-6"></div>
            </div>
        </div>
    </div>
                        <!-- Display general errors from session -->
                        @if(session('error'))
                            <div class="alert alert-danger">
                                {{ session('error') }}
                            </div>
                        @endif

                        <!-- Display validation errors -->
                        @if($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <button class="btn btn-primary btn-lg" data-bs-toggle="modal" data-bs-target="#addStoreModal">
                            إضافــة متجــر جديــد
                        </button>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="font-family: 'Cairo', sans-serif;">اســـم المتجــر</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الصـــورة</th>
                                        <th style="font-family: 'Cairo', sans-serif;">لوجو</th>
                                        <th style="font-family: 'Cairo', sans-serif;"> الايميل </th>
                                        <th style="font-family: 'Cairo', sans-serif;">الوصف</th>
                                        <th style="font-family: 'Cairo', sans-serif;">العمليـــات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($stores as $index => $store)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $store->getTranslation('name', 'ar') }}</td>
                                        <td>
                                            @if ($store->image)
                                            <img width="120" height="120" src="{{ asset('storage/'.$store->image) }}">
                                            @else
                                            <span>لا يوجد صورة</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if ($store->image)
                                            <img width="120" height="120" src="{{ asset('storage/'.$store->logo) }}">
                                            @else
                                            <span>لا يوجد صورة</span>
                                            @endif
                                        </td>
                                        <td>{{ $store->email }}</td>
                                        <td>{{ $store->getTranslation('description', 'ar') }}</td>

                                        <td>
                                            <button class="btn btn-success" data-bs-toggle="modal"
                                                data-bs-target="#edit{{ $store->id }}">
                                                <i class="fa fa-edit"></i>
                                            </button>
                                            <button class="btn btn-danger" data-bs-toggle="modal"
                                                data-bs-target="#delete{{ $store->id }}">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    <!-- Edit Store Modal -->
                                    <div class="modal fade" id="edit{{ $store->id }}" tabindex="-1" role="dialog"
                                        aria-labelledby="editStoreLabel{{ $store->id }}" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <form action="{{ route('admin.stores.update', $store->id) }}"
                                                    method="POST" enctype="multipart/form-data">
                                                    @csrf
                                                    @method('PUT')
                                                    <!-- This tells Laravel to perform an update operation -->

                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="editStoreLabel{{ $store->id }}">
                                                            تعديل بيانات المتجر</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                            aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <!-- Store Name Arabic -->
                                                        <div class="mb-3">
                                                            <label>اسم المتجر (العربية)</label>
                                                            <input class="form-control" type="text" name="name_ar"
                                                                value="{{ $store->getTranslation('name', 'ar') }}"
                                                                required>
                                                        </div>

                                                        <!-- Store Name English -->
                                                        <div class="mb-3">
                                                            <label>Store Name (English)</label>
                                                            <input class="form-control" type="text" name="name_en"
                                                                value="{{ $store->getTranslation('name', 'en') }}"
                                                                required>
                                                        </div>

                                                        <!-- Store Email -->
                                                        <div class="mb-3">
                                                            <label>البريد الإلكتروني</label>
                                                            <input class="form-control" type="email" name="email"
                                                                value="{{ $store->email }}" required>
                                                        </div>

                                                        <!-- Store Password -->
                                                        <div class="mb-3">
                                                            <label>كلمة المرور</label>
                                                            <input class="form-control" type="password" name="password">
                                                            <small class="text-muted">إذا كنت لا ترغب في تغيير كلمة
                                                                المرور، يمكنك ترك الحقل فارغًا.</small>
                                                        </div>

                                                        <!-- Store Description Arabic -->
                                                        <div class="mb-3">
                                                            <label>وصف المتجر (العربية)</label>
                                                            <textarea class="form-control"
                                                                name="description_ar">{{ $store->getTranslation('description', 'ar') }}</textarea>
                                                        </div>

                                                        <!-- Store Description English -->
                                                        <div class="mb-3">
                                                            <label>Store Description (English)</label>
                                                            <textarea class="form-control"
                                                                name="description_en">{{ $store->getTranslation('description', 'en') }}</textarea>
                                                        </div>

                                                        <!-- Store Image -->
                                                        <div class="mb-3">
                                                            <label>صورة المتجر</label>
                                                            <input class="form-control" type="file" name="image">
                                                            @if ($store->image)
                                                            <img src="{{ asset('storage/' . $store->image) }}"
                                                                width="100" height="120" class="mt-2">
                                                            @else
                                                            <span>No image available</span>
                                                            @endif
                                                        </div>
                                                        <div class="mb-3">
                                                            <label>لوجو المتجر</label>
                                                            <input class="form-control" type="file" name="logo">
                                                            @if ($store->logo)
                                                            <img src="{{ asset('storage/' . $store->logo) }}"
                                                                width="100" height="120" class="mt-2">
                                                            @else
                                                            <span>No logo available</span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary"
                                                            data-bs-dismiss="modal">إغلاق</button>
                                                        <button type="submit" class="btn btn-primary">تحديث</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Delete Store Modal -->
                                    <div class="modal fade" id="delete{{ $store->id }}" tabindex="-1" role="dialog"
                                        aria-labelledby="deleteStoreLabel{{ $store->id }}" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <form action="{{ route('admin.stores.destroy', $store->id) }}"
                                                    method="POST">
                                                    @csrf
                                                    @method('DELETE')
                                                    <!-- This tells Laravel to perform a delete operation -->

                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="deleteStoreLabel{{ $store->id }}">
                                                            حذف المتجر</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                            aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <p>هل أنت متأكد أنك تريد حذف المتجر؟</p>
                                                        <p class="text-danger">هذا الإجراء لا يمكن التراجع عنه!</p>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary"
                                                            data-bs-dismiss="modal">إغلاق</button>
                                                        <button type="submit" class="btn btn-danger">حذف</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Store Modal -->
    <div class="modal fade" id="addStoreModal" tabindex="-1" role="dialog" aria-labelledby="addStoreLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <form action="{{ route('admin.stores.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title" id="addStoreLabel">إضافــة متجــر جديــد</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label>اســم المتجــر</label>
                            <input class="form-control" type="text" name="name_ar" required>
                        </div>
                        <div class="mb-3">
                            <label>اســم المتجــر بالإنجليزي</label>
                            <input class="form-control" type="text" name="name_en" required>
                        </div>
                        <div class="mb-3">
                            <label>البريــد الإلكتروني</label>
                            <input class="form-control" type="email" name="email" required>
                        </div>
                        <div class="mb-3">
                            <label>كلمــة المــرور</label>
                            <input class="form-control" type="password" name="password" required>
                        </div>
                        <div class="mb-3">
                            <label>الصـــورة</label>
                            <input class="form-control" type="file" name="image">
                        </div>
                        <div class="mb-3">
                            <label>اللوجو</label>
                            <input class="form-control" type="file" name="logo">
                        </div>
                        <div class="mb-3">
                            <label>وصــف المتجــر</label>
                            <textarea class="form-control" name="description_ar"></textarea>
                        </div>
                        <div class="mb-3">
                            <label>وصــف المتجــر بالإنجليزي</label>
                            <textarea class="form-control" name="description_en"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">إغلاق</button>
                        <button class="btn btn-primary" type="submit">حفظ</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- Container-fluid Ends-->

@endsection
@section('js')
@include('admin.layouts.js')
@endsection