@extends('admin.layouts.master')
@section('title')

@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
<!-- Page Sidebar Ends-->
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">اعــــدادات الموقـــــــع</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">الاعـــــدادات</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h5 style="font-family: 'Cairo', sans-serif;">اعـــدادات الموقـــــع</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST" enctype="multipart/form-data" action="{{ route('admin.setting.update') }}">
                            @csrf

                            <!-- Social Media Links -->
                            @php
                            $socialLinks = [
                            'facebook' => 'رابط الفيسبوك',
                            'x' => 'رابط تويتر',
                            'instagram' => 'رابط انستاجرام',
                            'youtube' => 'رابط اليوتيوب',
                            'tiktok' => 'رابط تيك توك',
                            ];
                            @endphp

                            <div class="row g-3">
                                @foreach ($socialLinks as $key => $label)
                                <div class="col-md-4">
                                    <label class="form-label" style="font-family: 'Cairo', sans-serif;">{{ $label
                                        }}</label>
                                    <input style="border:solid 1px #555" class="form-control" type="text"
                                        name="{{ $key }}" value="{{ $setting->$key ?? '' }}">
                                </div>
                                @endforeach
                            </div>
                            <br>
                            <!-- Site Information -->
                            <div class="row g-3">
                                <div class="col-md-4">
                                    <label class="form-label" style="font-family: 'Cairo', sans-serif;">اسم
                                        الموقع</label>
                                    <input style="border:solid 1px #555" class="form-control" type="text"
                                        name="name_site" value="{{ $setting->name_site ?? '' }}">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-family: 'Cairo', sans-serif;">رقم
                                        الهاتف</label>
                                    <input style="border:solid 1px #555" class="form-control" type="text" name="phone"
                                        value="{{ $setting->phone ?? '' }}">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" style="font-family: 'Cairo', sans-serif;">العنوان</label>
                                    <input style="border:solid 1px #555" class="form-control" type="text" name="address"
                                        value="{{ $setting->address ?? '' }}">
                                </div>
                            </div>
                            <br>
                            <!-- Logo Upload -->
                            <div class="row g-3">
                                <div class="col-md-4">
                                    <label class="form-label" style="font-family: 'Cairo', sans-serif;">اختر شعار
                                        الموقع</label>
                                    <input name="logo" style="border:solid 1px #555" class="form-control" type="file">
                                </div>
                                <div class="col-md-2">
                                    <img src="{{  asset('storage/'.$setting->logo) }}" alt="Logo" width="100"
                                        height="100">
                                </div>
                            </div>

                            <br>

                            <!-- Submit Button -->
                            <div class="d-flex justify-content-end">
                                <button class="btn btn-primary" type="submit"
                                    style="font-family: 'Cairo', sans-serif;">حفظ</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
@include('admin.layouts.js')

@endsection