@extends('dashboard.layouts.master')
@section('title')

@endsection
@section('css')
@include('dashboard.layouts.css')
@endsection
@section('body')
<!-- Page Sidebar Ends-->
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;"> مقالات </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">قائمة الصلاحيات </li>
                    </ol>
                </div>
                <div class="col-sm-6"></div>
            </div>
        </div>
    </div>

    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <div class="container-fluid">
        <div class="main-content d-flex flex-column">
            <div class="card bg-white border-0 rounded-3 mb-4">
                <div class="card-body p-0">
                    <div class="d-flex justify-content-between align-items-center flex-wrap gap-3 p-4">
                        <h3 class="mb-0"> قائمة الصلاحيات </h3>
                    </div>

                    <div class="default-table-area style-two all-products">
                        <div class="table-responsive">
                            <table class="table align-middle">
                                <thead>
                                    <tr>
                                        <th scope="col"> الرقم التعريفي </th>
                                        <th scope="col"> الاسم </th>
                                        <th scope="col"> المجموعة </th>
                                        <th scope="col"> الدور </th>
                                        <th scope="col">الإجراءات</th> <!-- Action buttons -->
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($permissions as $permission)
                                    <tr>
                                        <td class="text-body">{{ $permission->id}}</td>
                                        <td class="text-secondary">{{ $permission->name }}</td>
                                        <td class="text-secondary">{{ $permission->group }}</td>
                                        <td class="text-secondary">{{ $permission->action }}</td>
                                        <td>
                                            @can('admin.roles.delete')
                                            <div class="d-flex align-items-center gap-1">
                                                <form action="{{ route('permissions.destroy', $permission->id) }}"
                                                    method="POST"
                                                    onsubmit="return confirm('Are you sure you want to delete this permission?');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button
                                                        class="ps-0 border-0 bg-transparent lh-1 position-relative top-2"
                                                        data-bs-toggle="tooltip" data-bs-placement="top"
                                                        data-bs-title="Delete">
                                                        <i
                                                            class="material-symbols-outlined fs-16 text-danger">delete</i>
                                                    </button>
                                                </form>
                                            </div>
                                            @endcan

                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <nav aria-label="Page navigation">
                            <ul class="pagination">
                                <!-- Previous Page Link -->
                                @if ($permissions->onFirstPage())
                                <li class="page-item disabled">
                                    <a class="page-link">السابق</a>
                                </li>
                                @else
                                <li class="page-item">
                                    <a class="page-link" href="{{ $permissions->previousPageUrl() }}"
                                        aria-label="Previous">
                                        السابق </a>
                                </li>
                                @endif

                                <!-- Pagination Links -->
                                @foreach ($permissions->links()->elements[0] as $page => $link)
                                @if ($page == $permissions->currentPage())
                                <li class="page-item active" aria-current="page">
                                    <a class="page-link">{{ $page }}</a>
                                </li>
                                @else
                                <li class="page-item">
                                    <a class="page-link" href="{{ $link }}">{{ $page }}</a>
                                </li>
                                @endif
                                @endforeach

                                <!-- Next Page Link -->
                                @if ($permissions->hasMorePages())
                                <li class="page-item">
                                    <a class="page-link" href="{{ $permissions->nextPageUrl() }}" aria-label="Next">
                                        التالي</a>
                                </li>
                                @else
                                <li class="page-item disabled">
                                    <a class="page-link"> التالي</a>
                                </li>
                                @endif
                            </ul>
                        </nav>

                    </div>

                </div>
            </div>
            <div class="flex-grow-1"></div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    ClassicEditor
    .create(document.querySelector('#editor1')) // المحرر العربي
    .catch(error => {
        console.error(error);
    });

ClassicEditor
    .create(document.querySelector('#editor2')) // المحرر الإنجليزي
    .catch(error => {
        console.error(error);
    });

</script>
@include('dashboard.layouts.js')

@endsection