@extends('dashboard.layouts.master')
@section('title')

@endsection
@section('css')
@include('dashboard.layouts.css')
@endsection
@section('body')
<!-- Page Sidebar Ends-->
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3> الرسائل الوارده </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"></li>
                        <li class="breadcrumb-item"><a href="index.html">الرئيسية</a></li>
                        <li class="breadcrumb-item active"> الرسائل الوارده </li>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <!-- Bookmark Start-->
                    <!-- Bookmark Ends-->
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <!-- Footer callback Ends-->
            <!-- Custom toolbar elements Starts-->
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">

                    </div>
                    <div class="card-body table-responsive">
                        <table class="display" id="advance-12">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الاسم</th>
                                    <th>البريد الإلكتروني</th>
                                    <th>العنوان</th>
                                    <th>الرسالة</th>
                                    <th>تاريخ الإضافة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($contactMessages as $message)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $message->Name }}</td>
                                    <td>{{ $message->Email }}</td>
                                    <td>{{ $message->Subject }}</td>
                                    <td>{{ Str::limit($message->Message, 50) }}</td> <!-- Limit message length -->
                                    <td>{{ $message->created_at->format('Y-m-d H:i') }}</td> <!-- Format date -->
                                    <td>
                                        @can('admin.contact_messages.delete')
                                        <button class="btn btn-danger" type="button" data-bs-toggle="modal"
                                            data-bs-target="#deleteModal{{ $message->id }}">
                                            <i class="fa fa-remove"></i>
                                        </button>
                                        <button class="btn btn-sm btn-success" type="button" data-bs-toggle="modal"
                                            data-original-title="test"
                                            data-bs-target="#notificationModal166{{ $message->id}}"
                                            data-bs-original-title="" title=""><i class="fa fa-comment "></i>
                                        </button>
                                        @endcan

                                    </td>
                                </tr>
                                <!-- Delete Modal -->
                                <div class="modal fade" id="deleteModal{{ $message->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="deleteLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <form action="{{ route('contact_messages.destroy', $message->id) }}"
                                                method="POST">
                                                @csrf
                                                @method('DELETE')
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="deleteLabel">تأكيد الحذف</h5>
                                                    <button type="button" class="close" data-bs-dismiss="modal"
                                                        aria-label="إغلاق">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    <p>هل أنت متأكد أنك تريد حذف هذه الرسالة؟</p>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">إغلاق</button>
                                                    <button type="submit" class="btn btn-danger">حذف</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>


                                <!-- Modal Structure -->
                                <div class="modal fade" id="notificationModal166{{ $message->id }}" tabindex="-1"
                                    aria-labelledby="modalTitle" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <!-- Modal Header -->
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="modalTitle">عنوان الإشعار</h5>
                                                <!-- Arabic Title -->
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="Close"></button>
                                            </div>
                                            <!-- Modal Body -->
                                            <div class="modal-body">
                                                <p>هنا تذهب رسالة الإشعار الخاصة بك.</p> <!-- Arabic Body -->
                                                <form action="{{ route('send.mail') }}" method="POST">
                                                    @csrf
                                                    <div class="mb-3">
                                                        <label for="messageInput1{{ $message->id }}"
                                                            class="form-label">العنوان</label>
                                                        <input type="text" name="title"
                                                            id="messageInput1{{ $message->id }}">
                                                    </div>
                                                    <div class="mb-3">
                                                        <label for="messageInput{{ $message->id }}"
                                                            class="form-label">رسالتك</label>
                                                        <textarea class="form-control"
                                                            id="messageInput{{ $message->id }}" name="message" rows="3"
                                                            required></textarea>
                                                    </div>
                                                    <!-- Hidden Email Input -->
                                                    <input type="hidden" name="email" value="{{ $message->Email }}">
                                                    <input type="hidden" name="message_id" value="{{ $message->id }}">
                                            </div>
                                            <!-- Modal Footer -->
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                    data-bs-dismiss="modal">إغلاق</button> <!-- Arabic Close Button -->
                                                <button type="submit" class="btn btn-primary">إرسال البريد
                                                    الإلكتروني</button> <!-- Arabic Submit Button -->
                                            </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
</div>

@endsection
@section('js')
@include('dashboard.layouts.js')

@endsection