@extends('admin.layouts.master')
@section('title')

@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
<script>
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<!-- Page Sidebar Ends-->
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{url('admin/category')}}"> الأقسام الرئيسية</a></li>
                        <li class="breadcrumb-item">أضافة قسم رئيسي</li>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <!-- Bookmark Start-->
                    <div class="bookmark">
                    </div>
                    <!-- Bookmark Ends-->
                </div>
            </div>
        </div>
    </div>
    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h5 style="font-family: 'Cairo', sans-serif;">أضافـــة قســم رئيســي</h5>
                    </div>
                    <div class="card-body">
                        <form class="needs-validation" novalidate enctype="multipart/form-data" method="POST"
                            action="{{ route('admin.categories.store') }}">
                            @csrf
                            <div class="col-sm-12 col-xl-12 xl-100">
                                <div class="card">
                                    <div class="card-body">
                                        <ul class="nav nav-tabs" id="icon-tab" role="tablist">
                                            <li class="nav-item">
                                                <a class="nav-link active" id="icon-home-tab" data-bs-toggle="tab"
                                                    href="#icon-home" role="tab" aria-controls="icon-home"
                                                    aria-selected="true" style="font-family: 'Cairo', sans-serif;">
                                                    اللغــــة العربيــــة
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a class="nav-link" id="profile-icon-tab" data-bs-toggle="tab"
                                                    href="#profile-icon" role="tab" aria-controls="profile-icon"
                                                    aria-selected="false" style="font-family: 'Cairo', sans-serif;">
                                                    اللغـــة الانجليزيــــة
                                                </a>
                                            </li>
                                        </ul>

                                        <br>

                                        <div class="tab-content" id="icon-tabContent">
                                            <!-- Arabic Tab -->
                                            <div class="tab-pane fade show active" id="icon-home" role="tabpanel"
                                                aria-labelledby="icon-home-tab">
                                                <div class="form-control">
                                                    <div class="row g-3">
                                                        <div class="col-md-10">
                                                            <label class="form-label"
                                                                style="font-family: 'Cairo', sans-serif;">اسم القسم
                                                                الرئيسي باللغــة العربيـــة</label>
                                                            <input name="name_ar" class="form-control" type="text"
                                                                style="border:solid 1px #555" required>
                                                        </div>
                                                    </div>
                                                    <br>
                                                </div>
                                            </div>
                                            <!-- English Tab -->
                                            <div class="tab-pane fade" id="profile-icon" role="tabpanel"
                                                aria-labelledby="profile-icon-tab">
                                                <div class="form-control">
                                                    <div class="row g-3">
                                                        <div class="col-md-10">
                                                            <label class="form-label"
                                                                style="font-family: 'Cairo', sans-serif;">اسم القسم
                                                                الرئيسي باللغــة الانجليزيـــة</label>
                                                            <input name="name_en" class="form-control" type="text"
                                                                style="border:solid 1px #555" required>
                                                        </div>
                                                    </div>
                                                    <br>
                                                </div>
                                            </div>

                                        </div>

                                        <!-- Image Uploads -->
                                        <div class="row g-3">
                                            <div class="col-md-4">
                                                <label>اختر الصورة الخاصة بالموقع للغة العربية</label>
                                                <input name="image" class="form-control" type="file"
                                                    style="border:solid 1px #555" required>
                                            </div>
                                        </div>

                                        <br>
                                        <div class="col-md-3">
                                            <label for="CategoryID" class="mr-sm-2"
                                                style="font-family: 'Cairo', sans-serif;">اختر القسم الرئيسي </label>
                                            <div class="box dropdown-content">
                                                <select name="CategoryID" id="category_id" class="form-control"
                                                    required>
                                                    <option value="" disabled>اختر القسم الرئيسي</option>
                                                    @foreach ($categories as $category)
                                                    <option value="{{ $category->id }}">{{ $category->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <button type="submit" class="btn btn-primary">حفظ البيانات</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
</div>

@endsection
@section('js')
<!-- latest jquery -->
<script>
    ClassicEditor
    .create(document.querySelector('#editor1')) // المحرر العربي
    .catch(error => {
        console.error(error);
    });

ClassicEditor
    .create(document.querySelector('#editor2')) // المحرر الإنجليزي
    .catch(error => {
        console.error(error);
    });

</script>
@include('admin.layouts.js')

@endsection