<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('custom_part_request_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('custom_part_request_id')->constrained()->onDelete('cascade');
            $table->string('name');
            $table->integer('quantity');
            $table->text('notes')->nullable();
            $table->string('image')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('custom_part_request_items');
    }
};