<?php

namespace App\Notifications;

use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\DatabaseMessage;
use App\Services\FirebaseNotificationService;

class NewCustomPartRequestNotification extends Notification
{
    protected $data;

    public function __construct(array $data)
    {
        $this->data = $data;
    }

    public function via($notifiable)
    {
        return ['database', FirebaseNotificationService::class];
    }

    public function toDatabase($notifiable)
    {
        return new DatabaseMessage([
            'custom_part_request_id' => $this->data['custom_part_request_id'],
            'message' => $this->data['message'],
        ]);
    }

    public function toFirebase($notifiable)
    {
        return [
            'title' => 'New Custom Part Request',
            'body' => $this->data['message'],
            'data' => [
                'custom_part_request_id' => (string) $this->data['custom_part_request_id'],
            ],
        ];
    }
}