<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Vendor extends Authenticatable
{
    use HasFactory, SoftDeletes, Notifiable;

    protected $fillable = [
        'name',
        'email',
        'phone',
        'password',
        'city_id',
        'address',
        'image',
        'description',
        'is_active'
    ];

    protected $hidden = ['password'];

    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function spareParts()
    {
        return $this->hasMany(SparePart::class);
    }

    public function carsForSale()
    {
        return $this->hasMany(CarForSale::class);
    }

    public function customPartRequests()
    {
        return $this->hasMany(CustomPartRequest::class);
    }
}