<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TowRequest extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'phone',
        'current_address',
        'destination_address',
        'problem_description',
        'user_id',
        'status'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function notifications()
    {
        return $this->morphMany(Notification::class, 'related');
    }
}