<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphOne;
class SiteDetail extends Model
{
    use HasFactory;

    protected $fillable = ['key', 'title', 'body', 'short_description'];

    // public $translatable = ['title', 'body', 'short_description'];
    public function image(): MorphOne
    {
        return $this->morphOne(Image::class, 'imageable');
    }
}