<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class OrderItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'spare_part_id',
        'order_id',
        'quantity',
        'unit_price',
        'has_discount',
        'discount_amount'
    ];

    public function sparePart()
    {
        return $this->belongsTo(SparePart::class);
    }

    public function order()
    {
        return $this->belongsTo(Order::class);
    }
}