<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Translatable;

class ModelSlider extends Model
{
    use Translatable;

    protected $fillable = ['model_id', 'image_url', 'title', 'order', 'is_active'];

    protected $casts = [
        'title' => 'array',
        'is_active' => 'boolean',
    ];

    public function model()
    {
        return $this->belongsTo(Model::class);
    }

    public function getTitleAttribute($value)
    {
        return $this->translateName($value);
    }
}