<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Image extends Model
{
    use HasFactory;

    protected $fillable = ['path', 'imageable_id', 'imageable_type'];
    const UPLOADED_FILES = 'uploads/images';
    public function imageable()
    {
        return $this->morphTo();
    }

    public function getImagePathAttribute($value)
    {
        return $this->path ? asset('public/' . self::UPLOADED_FILES . '/' . $this->path) : null;
    }
}