<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomPartRequest extends Model
{
    use HasFactory;

    protected $fillable = ['model_id', 'category_id', 'vendor_id', 'description', 'status', 'user_id', 'address'];

    public function model()
    {
        return $this->belongsTo(CarModel::class);
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function vendor()
    {
        return $this->belongsTo(Vendor::class);
    }

    public function items()
    {
        return $this->hasMany(CustomPartRequestItem::class);
    }

    public function notifications()
    {
        return $this->morphMany(Notification::class, 'related');
    }
}