<?php
namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class VendorResource extends JsonResource
{
    public function toArray($request)
    {
        $locale = $request->header('Accept-Language', 'ar');
        $locale = in_array($locale, ['ar', 'en']) ? $locale : 'ar';

        return [
            'id' => $this->id,
            'name' => is_array($this->name) ? ($this->name[$locale] ?? null) : (
                json_decode($this->name, true)[$locale] ?? null
            ),
            'email' => $this->email,
            'phone' => $this->phone,
            'city_id' => $this->city_id,
            'city_name' => $this->city ? (
                is_array($this->city->name) ? ($this->city->name[$locale] ?? null) : (
                    json_decode($this->city->name, true)[$locale] ?? null
                )
            ) : null,
            'address' => $this->address,
            'image' => $this->image,
            'description' => $this->description,
            'is_active' => $this->is_active,
            'created_at' => $this->created_at?->toIso8601String(),
            'updated_at' => $this->updated_at?->toIso8601String(),
            'deleted_at' => $this->deleted_at?->toIso8601String(),
        ];
    }
}