<?php
namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CarForSaleResource extends JsonResource
{
    public function toArray($request)
    {
        $locale = app()->getLocale();

        return [
            'id' => $this->id,
            'model' => new ModelResource($this->model),
            'image' => asset('storage/' . $this->image),
            'price' => $this->price,
            'mileage' => $this->mileage,
            'description' => $this->description,
            'inspection_location' => $this->inspection_location,
            'whatsapp_number' => $this->whatsapp_number,
            'phone_number' => $this->phone_number,
            'installment_available' => $this->installment_available,
            'notes' => $this->notes,
            'transmission_type' => $this->transmission_type,
            'production_year' => $this->production_year,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}