<?php

namespace App\Http\Controllers\MobileApi;

use App\Models\Winch;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class WinchController extends Controller
{
    public function index()
    {
        $winches = Winch::all();
        return response()->json([
            'status' => 'success',
            'data' => $winches
        ], 200);
    }

    // POST: إضافة بيانات جديدة
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'phone_number' => 'required|string|max:15',
            'car_description' => 'required|string',
            'current_address' => 'required|string|max:255',
            'destination_address' => 'required|string|max:255',
            'issue' => 'required|string',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'errors' => $validator->errors()
            ], 422);
        }

        $winch = Winch::create($request->all());

        return response()->json([
            'status' => 'success',
            'message' => 'Winch created successfully',
            'data' => $winch
        ], 201);
    }
}